/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.offline;

import java.util.List;

/**
 * Represents a paragraph, containing (optional) text and (optional) {@link Picture}s.
 */
public interface Paragraph {

    /**
     * @return the paragraph text with all formatting removed
     */
    public String getText();

    /**
     * @return the paragraph text as HTML (well-formed XML in the empty namespace, not the XHTML namespace)
     */
    public String getHTML();

    /**
     * @return the pictures included in the paragraph
     */
    public List<Picture> getPictures();
}
