/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.offline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.jackrabbit.util.ISO9075;

/**
 * Simple support for converting style names to class names, and for mapping
 * class names to HTML element names.
 */
public class WordStyleSupport {

    private static final String PREFIX = "wic-";

    private static final Map<String, String> ELEMENTLOOKUP;

    static {
        Map<String, String> tmp = new HashMap<String, String>();
        tmp.put(PREFIX + "heading1", "h1");
        tmp.put(PREFIX + "heading2", "h2");
        tmp.put(PREFIX + "heading3", "h3");
        tmp.put(PREFIX + "heading4", "h4");
        tmp.put(PREFIX + "heading5", "h5");
        tmp.put(PREFIX + "heading6", "h6");
        ELEMENTLOOKUP = Collections.unmodifiableMap(tmp);
    }

    /**
     * Generate a HTML class name based on a Word style.
     * 
     * @param styleName
     *            Word style name
     * @return class name
     */
    public static String makeClassName(String styleName) {
        if (styleName == null) {
            return PREFIX + "normal";
        } else {
            return PREFIX + ISO9075.encode(styleName.toLowerCase(Locale.ENGLISH).trim().replace(" ", ""));
        }
    }

    /**
     * Generate an HTML element name based on a class name generated by
     * {@link WordStyleSupport#makeClassName(String)}.
     * 
     * @param className
     *            class name
     * @return element name or <code>null</code>
     */
    public static String toHtmlElement(String className) {
        return ELEMENTLOOKUP.get(className);
    }
}
