/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.siteimporter;

import java.net.URL;
import java.util.Hashtable;

import com.day.cq.wcm.siteimporter.internal.resource.BinaryImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.CssImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.HtmlImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.ImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.JsImporterResource;

public class ResourcesBoard {
    public static final int HTML = 0;
    public static final int CSS = 1;
    public static final int JS = 2;
    public static final int BINARY = 3;

    private Hashtable<String, ImporterResource> resources = new Hashtable<String, ImporterResource>();

    public ImporterResource getResource(URL location, int type,
            ImporterContext ctx) {
        if (resources.containsKey(location.toString())) {
            return resources.get(location.toString());
        }
        ImporterResource resource = createResource(location, type, ctx);
        resources.put(location.toString(), resource);
        return resource;
    }

    public ImporterResource getResource(URL location, ImporterContext ctx) {
        return getResource(location, extractType(location), ctx);
    }

    private int extractType(URL location) {
        String resourcePath = location.getPath();
        int lastSlash = resourcePath.lastIndexOf("/");
        int lastDot = resourcePath.lastIndexOf(".");
        String extension = "";
        if (lastSlash < lastDot) {
            extension = resourcePath.substring(lastDot + 1).toLowerCase();
        }
        if ("js".equals(extension)) {
            return JS;
        }
        if ("css".equals(extension)) {
            return CSS;
        }
        if ("html".equals(extension) || "htm".equals(extension)) {
            return HTML;
        }
        return BINARY;
    }

    private ImporterResource createResource(URL location, int type,
            ImporterContext ctx) {
        if (resources.contains(location)) {
            return resources.get(location);
        }
        if (type == HTML) {
            return new HtmlImporterResource(location, ctx);
        }
        if (type == CSS) {
            return new CssImporterResource(location, ctx);
        }
        if (type == JS) {
            return new JsImporterResource(location, ctx);
        }
        if (type == BINARY) {
            return new BinaryImporterResource(location, ctx);
        }
        return null;
    }
}
