/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.webservicesupport;

import java.util.Iterator;

import org.apache.jackrabbit.JcrConstants;
import org.apache.sling.api.resource.Resource;

/**
 * Provides utility methods for web service configurations.
 * 
 * @since 5.5
 */
public class ConfigurationUtil {

    /**
     * Checks if the given {@link Resource} is a service. The resource is a
     * service if the content child node is of resource type
     * 'cq/configurations/components/servicepage'.
     * 
     * @param resource {@link Resource} that will be tested.
     * @return <code>true</code> if the {@link Resource} has a service resource
     *         type, <code>false</code> otherwise
     */
    public static final Boolean isService(Resource resource) {
        Resource child = resource.getChild(JcrConstants.JCR_CONTENT);
        return (child != null && child.isResourceType(ConfigurationConstants.RT_SERVICE));
    }
    
    /**
     * Checks if the given {@link Resource} is a configuration. The resource is
     * a configuration if the contentn child node is of resource type
     * 'cq/configurations/components/configpage'.
     * 
     * @param resource {@link Resource} that will be tested.
     * @return <code>true</code> if the {@link Resource} has a configuration
     *         resource type, <code>false</code> otherwise
     */
    public static final Boolean isConfiguration(Resource resource) {
        Resource child = resource.getChild(JcrConstants.JCR_CONTENT);
        return (child != null && child.isResourceType(ConfigurationConstants.RT_CONFIGURATION));
    }

    /**
     * Checks if the given {@link Resource} has child configurations.
     * 
     * @param resource {@link Resource} that will be tested.
     * @return <code>true</code> if the {@link Resource} has at least a child configuration
     *         resource, <code>false</code> otherwise
     */
    public static final Boolean hasConfigurations(Resource resource) {
        for(Iterator<Resource> it = resource.listChildren(); it.hasNext();) {
            Resource child = it.next();
            if (ConfigurationUtil.isConfiguration(child)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}
