/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2015 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.wcm.webservicesupport;

import java.util.List;

import aQute.bnd.annotation.ProviderType;

/**
 * The <code>ServiceLibFinder</code> provides methods to look up JS Library Code for Page-inclusion
 */
@ProviderType
public interface ServiceLibFinder {

    /**
     * Returns the path of the scripts defined by the services for head inclusion.
     * @param servicePaths array of servicePaths.
     * @return Paths to the scripts that should be included for the services to work in a page
     */
    List<String> getScriptPaths(String[] servicePaths);

    /**
     * Returns the component references defined by the services for head inclusion.
     * 
     * <p>
     * A component reference is simply a resource type, e.g. the cq/webservices/components/mywebservice
     * 
     * @param servicePaths array of servicePaths.
     * @return a list of component references, possiby empty, but never null
     */
    List<String> getComponentReferences(String[] servicePaths);

}
