/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.workflow.process;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.workflow.exec.WorkflowProcess;

/**
 * <code>ReverseReplicateProcess</code>
 * Process for reverse replications of type <i>activate</i>.
 *
 * @see ReplicatePageProcess
 */
@Component
@Service(WorkflowProcess.class)
@Property(name = "process.label", value = "Reverse Replicate Content")
public class ReverseReplicateProcess extends ReplicatePageProcess {

    /**
     * filter for replicate on modification agents that should also
     * include reverse replication ("distribute") agents
     */
    private static final AgentFilter MOD_DISTRIBUTE_FILTER = new AgentFilter(){
        public boolean isIncluded(Agent agent) {
            return agent.getConfiguration().isTriggeredOnDistribute();
        }
    };

    @Override
    public ReplicationActionType getReplicationType() {
        return ReplicationActionType.ACTIVATE;
    }

    @Override
    protected ReplicationOptions prepareOptions(ReplicationOptions opts) {
        if (opts == null) {
            opts = new ReplicationOptions();
        }
        opts.setFilter(MOD_DISTRIBUTE_FILTER);
        opts.setSuppressStatusUpdate(true);
        return opts;
    }
}