/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow;

import java.util.Dictionary;

import com.day.cq.workflow.metadata.MetaDataMap;

/**
 * Interface for workflow entities that provide meta data.
 */
public interface HasMetaData {
    /**
     * Provides meta data assigned to the entity.
     * 
     * @return The map of meta data assigned to the entity.
     * @deprecated It's recommended to use {@link #getMetaDataMap()} instead.
     */
    Dictionary<String, String> getMetaData();

    /**
     * Provides meta data assigned to the entity, supporting any type.
     * 
     * @return A meta data map.
     * @see MetaDataMap
     * @since 5.4
     */
    MetaDataMap getMetaDataMap();
}
