/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.model;

import java.util.List;

import com.day.cq.workflow.HasMetaData;

/**
 * <code>WorkflowModel</code> represents a model/definition of a workflow.
 * 
 * It provides methods for retrieving the entities of the model like
 * <code>{@link WorkflowNode}</code>s and
 * <code>{@link WorkflowTransition}</code>s as well as common model attributes
 * like name, description or version.
 */
public interface WorkflowModel extends HasMetaData {
    /**
     * Returns the ID of the <code>WorkflowModel</code>.
     * 
     * @return The ID of the <code>WorkflowModel</code>.
     */
    String getId();

    /**
     * Returns the title of the <code>WorkflowModel</code>.
     * 
     * @return The title of the <code>WorkflowModel</code>.
     */
    String getTitle();

    /**
     * Sets the title of the <code>WorkflowModel</code>.
     * 
     * @param title
     *            The new title of the <code>WorkflowModel</code>.
     */
    void setTitle(String title);

    /**
     * Returns the description of the <code>WorkflowModel</code>.
     * 
     * @return The description of the <code>WorkflowModel</code>.
     */
    String getDescription();

    /**
     * Sets the description of the <code>WorkflowModel</code>.
     * 
     * @param description
     *            The new description of the <code>WorkflowModel</code>.
     */
    void setDescription(String description);

    /**
     * Returns the version of the <code>WorkflowModel</code>.
     * 
     * @return The version of the <code>WorkflowModel</code>.
     */
    String getVersion();

    /**
     * Returns the list of <code>{@link WorkflowNode}</code>s contained by the
     * <code>WorkflowModel</code>.
     * 
     * @return The list of <code>{@link WorkflowNode}</code>s of the
     *         <code>WorkflowModel</code>.
     */
    List<WorkflowNode> getNodes();

    /**
     * TODO
     */
    WorkflowNode createNode();

    /**
     * TODO
     */
    WorkflowNode createNode(String title, String type, String description);

    /**
     * TODO
     */
    public void setRootNode(WorkflowNode node);

    /**
     * TODO
     */
    public void setEndNode(WorkflowNode node);

    /**
     * Returns the <code>{@link WorkflowNode}</code> with the given id
     * 
     * @param id
     *            The ID of the <code>{@link WorkflowNode}</code>.
     * 
     * @return The <code>WorkflowNode</code> or null if not found.
     */
    WorkflowNode getNode(String id);

    /**
     * Returns the root/start <code>{@link WorkflowNode}</code>.
     * 
     * @return The root <code>{@link WorkflowNode}</code>.
     */
    WorkflowNode getRootNode();

    /**
     * Returns the end <code>{@link WorkflowNode}</code>.
     * 
     * @return The end <code>{@link WorkflowNode}</code>.
     */
    WorkflowNode getEndNode();

    /**
     * Returns the list of <code>{@link WorkflowTransition}</code>s contained by
     * the <code>WorkflowModel</code>.
     * 
     * @return The list of <code>{@link WorkflowTransition}</code>s of the
     *         <code>WorkflowModel</code>.
     */
    List<WorkflowTransition> getTransitions();

    /**
     * TODO
     */
    WorkflowTransition createTransition();

    /**
     * TODO
     */
    WorkflowTransition createTransition(WorkflowNode from, WorkflowNode to,
            String rule);

    /**
     * Validates the model.
     * 
     * @throws ValidationException
     */
    void validate() throws ValidationException;
}
