/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.model;

/**
 * Interface for <code>{@link WorkflowModel}</code> filter implementation which
 * can be used to filter the result set when retrieving models.
 */
public interface WorkflowModelFilter {
    /**
     * Filter method which is called to check if a model should be filtered out
     * from the result set or not.
     * 
     * @return Returns true if the model should be included, otherwise false.
     */
    boolean doInclude(WorkflowModel model);
}
