/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.model;

/**
 * <code>WorkflowModelSerializer</code> is the interface for services that
 * provide functionality for de-/serialising
 * <code>{@link WorkflowModel}</codes> from/to other (textual) representations.
 */
public interface WorkflowModelSerializer {
	/**
	 * Property for the type serialization type of the
	 * <code>WorkflowModelSerializer</code>.
	 */
	public static final String TYPE = "com.day.cq.workflow.serialzer.type";

	/**
	 * Property for the mime type of the serialization format of the
	 * <code>WorkflowModelSerializer</code>.
	 */
	public static final String MIME_TYPE = "com.day.cq.workflow.serialzer.mime";

	/**
	 * Returns the type of the <code>WorkflowModelSerializer</code>. Must
	 * return a unique string describing the type of the
	 * <code>WorkflowModelSerializer</code> and serialization format
	 * respectively.
	 * 
	 * @return Unique string identifier for the type of the
	 *         <code>WorkflowModelSerializer</code> and serialization format.
	 */
	String getType();

	/**
	 * Returns the mime type of the <code>WorkflowModelSerializer</code>s
	 * serialization format.
	 * 
	 * @return The mime type of the serialized format.
	 */
	String getMimeType();

	/**
	 * Serializes the given <code>{@link WorkflowModel}</codes> into a textual 
	 * representation.
	 * 
	 * @param model 
	 * 			The <code>{@link WorkflowModel}</codes> to be serialized.
	 * 
	 * @return A serialized (textual) representation of the 
	 * 			<code>{@link WorkflowModel}</codes>.
	 */
	String serialize(WorkflowModel model) throws Exception;

	/**
	 * Deserializes a <code>{@link WorkflowModel}</codes> instance from the 
	 * given (textual) model definition.
	 * 
	 * @param modelDefinition The model definition as string.
	 * 
	 * @return The deserialized <code>{@link WorkflowModel}</codes>.
	 */
	WorkflowModel deserialize(String modelDefinition) throws Exception;
}
