/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.model;

import com.day.cq.workflow.HasMetaData;

/**
 * <code>WorkflowTransition</code> represents a transition between two
 * <code>{@link WorkflowNode}</code>s of a <code>{@link WorkflowModel}</code>.
 */
public interface WorkflowTransition extends HasMetaData {
	/**
	 * Returns the <code>{@link WorkflowNode}</code> that is the source of
	 * this <code>WorkflowTransition</code>.
	 * 
	 * @return The <code>{@link WorkflowNode}</code> that is the source of
	 *         this <code>WorkflowTransition</code>.
	 */
	WorkflowNode getFrom();

	/**
	 * Sets the <code>{@link WorkflowNode}</code> that is the source of this
	 * <code>WorkflowTransition</code>.
	 * 
	 * @param from
	 *            The <code>{@link WorkflowNode}</code> that is the source of
	 *            this <code>WorkflowTransition</code>.
	 */
	void setFrom(WorkflowNode from);

	/**
	 * Returns the <code>{@link WorkflowNode}</code> that is the target of
	 * this <code>WorkflowTransition</code>.
	 * 
	 * @return The <code>{@link WorkflowNode}</code> that is the target of
	 *         this <code>WorkflowTransition</code>.
	 */
	WorkflowNode getTo();

	/**
	 * Sets the <code>{@link WorkflowNode}</code> that is the target of this
	 * <code>WorkflowTransition</code>.
	 * 
	 * @param to
	 *            The <code>{@link WorkflowNode}</code> that is the target of
	 *            this <code>WorkflowTransition</code>.
	 */
	void setTo(WorkflowNode to);

	/**
	 * Returns the rule that defines if this <code>WorkflowTransition</code>
	 * can be followed or not.
	 * 
	 * @return The execution rule of the <code>WorkflowTransition</code>.
	 */
	String getRule();

	/**
	 * Sets the rules that defines if this <code>WorkflowTransition</code> can
	 * be followed or not.
	 * 
	 * @param rule
	 *            The execution rule of the <code>WorkflowTransition</code>.
	 */
	void setRule(String rule);
}
