/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.predicate;

import com.day.cq.commons.predicate.AbstractNodePredicate;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Predicate used to filter authorizable nodes for user selection.
 * 
 */
@Component(metatype = false)
@Service (value = Predicate.class)
@Property (name="predicate.name", value = "authorizable")
public class AuthorizablePredicate extends AbstractNodePredicate implements
        Predicate {

    /**
     * {@inheritDoc}
     * 
     * @return <code>true</code> if node must not be <code>hidden</code>
     */
    public boolean evaluate(Node node) throws RepositoryException {
        return node.isNodeType("rep:AuthorizableFolder")
                || node.isNodeType("rep:Authorizable");
    }
}