/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.serialization;

import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowModelSerializer;

/**
 * The <code>SerializationService</code> manages access to
 * <code>{@link WorkflowModelSerializer}</code> services.
 */
public interface SerializationService {
	/**
	 * Returns the mime type associated with a given type.
	 * 
	 * @param type
	 *            The type of the serialization format.
	 * 
	 * @return The mime type associated with the given type or NULL if no
	 *         serializer with the given type exists.
	 */
	String getMimeType(String type);

	/**
	 * Serializes the given <code>{@link WorkflowModel}</codes> into a textual 
	 * representation.
	 * 
	 * @param model 
	 * 			The <code>{@link WorkflowModel}</codes> to be serialized.
	 * @param type The type of the serialization format.
	 * 
	 * @return A serialized (textual) representation of the 
	 * 			<code>{@link WorkflowModel}</codes> or NULL if no serializer 
	 * 			with the given type was found.
	 */
	String serialize(WorkflowModel model, String type) throws Exception;

	/**
	 * Deserializes a <code>{@link WorkflowModel}</codes> instance from the 
	 * given (textual) model definition.
	 * 
	 * @param modelDefinition The model definition as string.
	 * @param type The type of the serialization format.
	 * 
	 * @return The deserialized <code>{@link WorkflowModel}</codes> or NULL if 
	 * 			no serializer with the given type was found.
	 */
	WorkflowModel deserialize(String modelDefinition, String type)
			throws Exception;
}
