/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.xss;

/**
 * This interface must be implemented by all services that can be used for preventing
 * XSS attacks.
 * @deprecated Use the {@link com.adobe.granite.xss.XSSFilter} instead.
 */
@Deprecated
public interface XSSProtectionService {

    /**
     * Invalidates the given policy.
     * <p>
     * This is used to declare cached policies as invalid and enforce reloading when
     * <code>protectFromXss()</code> is called the next time.
     * <p>
     * Invalidating policies manually is not necessary anymore, as changes get detetcted
     * automatically since CQ 5.4.
     *
     * @param policyPath policy path (as used for <code>protectFromXSS()</code>) to
     *                   invalidate
     */
    @Deprecated
    void invalidatePolicy(String policyPath);

    /**
     * Prevents the given source string from containing XSS stuff.
     * <p>
     * The default policy is used for checking.
     *
     * @param src source string
     * @return string that does not contain XSS stuff
     * @throws XSSProtectionException if loading the default policy or scanning the source
     *                                string didn't succeed.
     */
    String protectFromXSS(String src) throws XSSProtectionException;

    /**
     * Protects the given source string from containing XSS stuff.
     * <p>
     * The default policy is used for checking.
     *
     * @param src source string
     * @param policyPath path to policy configuration node; the default configuration will
     *                   be taken if this parameter is set to <code>null</code>
     * @return string that does not contain XSS stuff
     * @throws XSSProtectionException if loading the given policy or scanning the source
     *                                string didn't succeed.
     */
    String protectFromXSS(String src, String policyPath) throws XSSProtectionException;

    /**
     * Protected the given source string from containing XSS stuff, considering the
     * specified protection context.
     * <p>
     * For more information about protection contexts, see {@link ProtectionContext} and
     * http://www.owasp.org/index.php/XSS_%28Cross_Site_Scripting%29_Prevention_Cheat_Sheet
     *
     * @param context The protection context
     * @param src The string to protect
     * @param policyPath The path to a configuration node that contains the policy to be
     *                   used (dependant on the protection context); <code>null</code> to
     *                   use the default policy.
     * @return The protected <code>String</code>
     * @throws XSSProtectionException if loading the policy or scanning the source does not
     *                                succeed
     * @since 5.4
     */
    String protectForContext(ProtectionContext context, String src, String policyPath)
            throws XSSProtectionException;

    /**
     * Protected the given source string from containing XSS stuff, considering the
     * specified protection context.
     * <p>
     * For more information about protection contexts, see {@link ProtectionContext} and
     * http://www.owasp.org/index.php/XSS_%28Cross_Site_Scripting%29_Prevention_Cheat_Sheet
     *
     * @param context The protection context
     * @param src The string to protect
     * @return The protected <code>String</code>
     * @throws XSSProtectionException if loading the policy or scanning the source does not
     *                                succeed
     * @since 5.4
     */
    String protectForContext(ProtectionContext context, String src)
            throws XSSProtectionException;

}
