/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.core.cluster;

/**
 * Contains information about a cluster node.
 */
public class ClusterNodeInfo {

    /**
     * The node's id.
     */
    protected final String id;

    /**
     * The node's operating system.
     */
    private final String os;

    /**
     * The node's host name.
     */
    private final String hostname;

    /**
     * The node's repository home.
     */
    private final String repositoryHome;

    /**
     * Create a new instance of this class.
     */
    public ClusterNodeInfo(String id, String os, String hostname, String repositoryHome) {
        this.id = id;
        this.os = os;
        this.hostname = hostname;
        this.repositoryHome = repositoryHome;
    }

    /**
     * Return the node's id.
     *
     * @return id
     */
    public String getId() {
        return id;
    }

    /**
     * Return the node's operating system.
     *
     * @return operating system
     */
    public String getOS() {
        return os;
    }

    /**
     * Return the node's hostname.
     */
    public String getHostname() {
        return hostname;
    }

    /**
     * Return the node's repository home.
     *
     * @return repository home
     */
    public String getRepositoryHome() {
        return repositoryHome;
    }
}
