/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import com.day.crx.packaging.impl.proxy.AttributeList;
import com.day.crx.packaging.impl.proxy.DocumentHandler;
import com.day.crx.packaging.impl.proxy.HtmlParser;

/**
 * <code>HtmlStatusResponseParser</code>...
 */
public class HtmlStatusResponseParser {

    private final static Set<String> TAGS;
    static {
        Set<String> tags = new HashSet<String>();
        tags.add("A");
        tags.add("DIV");
        TAGS = Collections.unmodifiableSet(tags);
    }

    public static JSONResponse parse(String data) throws IOException {
        Handler h = new Handler();
        HtmlParser p = new HtmlParser();
        p.setDocumentHandler(h);
        p.setTagInclusionSet(TAGS);
        p.update(data.toCharArray(), 0, data.length());
        p.finished();
        return h.resp;
    }

    private static class Handler implements DocumentHandler {

        private String id = null;

        private int statusCode = 0;

        private String statusMessage = "";

        private final JSONResponse resp = new JSONResponse();


        public void characters(char[] ch, int off, int len) throws IOException {
            if (id == null) {
                return;
            }
            String str = new String(ch, off, len);
            if ("Status".equals(id)) {
                statusCode = Integer.parseInt(str);
                resp.setStatus(statusCode);
                resp.setSuccess(statusCode == 200);
            } else if ("Message".equals(id)) {
                statusMessage = str;
                resp.setMessage(statusMessage);
            } else if ("Path".equals(id)) {
                resp.setPath(str);
            } else if ("Referer".equals(id)) {
                //resp.setReferer(str);
            } else if ("Location".equals(id)) {
                resp.setLocation(str);
            } else if ("ParentLocation".equals(id)) {
                //resp.setParentLocation(str);
            }
            id = null;
        }

        public void onStartElement(String name, AttributeList attList, char[] ch, int off, int len, boolean endSlash) throws IOException {
            id = attList.getValue("id");
        }

        public void onEndElement(String name, char[] ch, int off, int len) throws IOException {
        }

        public void onStart() throws IOException {
        }

        public void onEnd() throws IOException {
        }
    }
}