/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONResponse {

    private static final Logger log = LoggerFactory.getLogger(JSONResponse.class);

    public static final String TEXT_HTML_UTF8 = "text/html; charset=utf-8";

    public static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";

    private int status = 200;

    private boolean success = true;

    private String message = "";

    private String path = "";

    private String data = "";

    private String location = "";

    private String contentType = APPLICATION_JSON_UTF8;

    private boolean jsonInTextarea = false;

    public JSONResponse() {
    }

    public JSONResponse(boolean success, String message) {
        this.success = success;
        this.message = message;
        this.status = success ? 200 : 500;
    }

    public JSONResponse(boolean success, String message, String path) {
        this.success = success;
        this.message = message;
        this.status = success ? 200 : 500;
        this.path = path;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void writeJsonInTextarea(boolean v) {
        if (v) {
            contentType = TEXT_HTML_UTF8;
            jsonInTextarea = true;
        }
    }

    public void send(HttpServletResponse response, boolean setStatus)
            throws IOException {
        if (setStatus) {
            response.setStatus(status);
            // special treatment of 201/CREATED: Requires Location
            if (status == HttpServletResponse.SC_CREATED) {
                response.setHeader("Location", location);
            }
        }
        response.setContentType(contentType);

        PrintWriter out = response.getWriter();
        if (jsonInTextarea) {
            out.print("<textarea>");
        }

        JSONWriter w = new JSONWriter(out);
        try {
            w.object();
            w.key("success").value(success);
            if (message.length() > 0) {
                w.key("msg").value(message);
            }
            if (path.length() > 0) {
                w.key("path").value(path);
            }
            if (data.length() > 0) {
                w.key("data").value(data);
            }
            if (location.length() > 0) {
                w.key("location").value(location);
            }
            w.endObject();
        } catch (JSONException e) {
            log.error("Error while writing json.");
            throw new IOException(e.toString());
        }

         if (jsonInTextarea) {
            out.print("</textarea>");
        }
   }

}