/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;


/**
 * <code>PackageInfo</code>...
 */
public abstract class PackageInfo {

    /**
     * Formats a size argument windows style.
     * @param size the size
     * @return the size formatted
     */
    public static String formatSize(long size) {
        String ret = "";
        String unit = " bytes";
        if (size > 1024*1024) {
            ret = String.valueOf(size / (1024*1024));
            unit = " MB";
        } else if (size > 1024) {
            ret = String.valueOf(size / 1024);
            unit = " KB";
        } else {
            ret = String.valueOf(size);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < ret.length(); i++) {
            if ((ret.length() - i) % 3 == 0 && i > 0) {
                buf.append('\'');
            }
            buf.append(ret.charAt(i));
        }
        buf.append(unit);
        return buf.toString();
    }


}