/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;

import java.io.IOException;

import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <code>PackageShare</code>...
 */
public interface PackageShare {

    public static final String COOKIE_ID_NAME = "daypsid";

    public static final String PARAM_CLIENT_ID_NAME = "daypsid";

    /**
     * Returns the session of the given id.
     * @param id the id
     * @return the session or <code>null</code>
     */
    PackageShareSession getSession(String id);

    /**
     * Returns the session with the id provided with the cookie in the given
     * request. returns <code>null</code> if no such cookie
     * @param req the request
     * @return the session or a anonymous session if not logged in yet.
     */
    PackageShareSession getSession(HttpServletRequest req);

    /**
     * Returns the session with the id provided with the cookie in the given
     * request.
     * @param req the request
     * @param resp the response
     * @return the session or a anonymous session if not logged in yet.
     */
    PackageShareSession getSession(HttpServletRequest req, HttpServletResponse resp);

    /**
     * Performs a login on the package share server. when login is successful,
     * the returned session is not anonymous. if connection failed, <code>null</code>
     * is returned. otherwise the session data will have:
     *
     * <pre>
     * {
     * server: {
     *   host: "https://dev.day.com",
     *   message: "Welcome. Server Ready..."
     * },
     * user: {
     *   anonymous: false,
     *   userId: "tripod",
     *   name: "Toby",
     *   company: "Day"
     * },
     * shares: {
     *   day: {
     *     title: "Day",
     *     readOnly: false
     *   },
     *   ...
     * }
     * </pre>
     *
     * @param session jcr session
     * @param req the request
     * @param resp the response
     * @param user user name
     * @param pass pass word
     * @return the session if successful or <code>null</code> if the login is invalid
     * @throws IOException if there was an error during I/O with the server.
     */
    PackageShareSession login(Session session,
                              HttpServletRequest req, HttpServletResponse resp,
                              String user, String pass) throws IOException;


}