/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.sling.commons.json.JSONObject;

/**
 * <code>PackageShareSession</code>...
 */
public interface PackageShareSession {

    /**
     * Checks if this session is the anonymous session.
     * @return <code>true</code> if this session is the anonymous session
     */
    boolean isAnonymous();

    /**
     * Returns the package share service
     * @return the service
     */
    PackageShare getService();

    /**
     * Returns the id of this session
     * @return the id.
     */
    String getId();

    /**
     * Returns the time in milliseconds when this session was aquired.
     * @return the creation time
     */
    long getCreationTime();

    /**
     * Checks if the session is new and never connected to the packageshare.
     * @return <code>true</code> if new.
     */
    boolean isNew();

    /**
     * Returns the id of the user that own this session
     * @return the user id
     */
    String getUserId();

    /**
     * Returns the name of the user
     * @return the name
     */
    String getUserName();

    /**
     * Returns a list of groups this use is allowed to write
     * @return list of groups
     */
    Set<String> getSharedGroups();

    /**
     * Returns the packages the user of this session can access.
     * @return the packages available.
     */
    Set<PackageInfo> getAvailablePackages();

    /**
     * Returns the JSON object of the session info provided by the server.
     * @return the json object or <code>null</code>
     */
    JSONObject getSessionInfo();

    /**
     * Logs this session out and discards it from the session pool
     */
    void logout();

    /**
     * Returns a proxy to the package share server
     * @param suppressId <code>true</code> to suppress automatic addition of the daypsid
     * @return the proxy
     */
    Proxy createProxy(boolean suppressId);

    /**
     * Uploads a package to the package share
     * @param file the file node
     * @param tracker the tracker
     * @param group desired package group
     * @return the status response form the server
     * @throws IOException if an error occurs
     * @throws RepositoryException if a repository error occurs
     */
    JSONResponse uploadPackage(Node file, ProxyTracker tracker, String group)
            throws IOException, RepositoryException;

    /**
     * Uploads a package to the package share
     * @param file the file
     * @param name the name
     * @param tracker the tracker
     * @param group desired package group
     * @return the status response form the server
     * @throws IOException if an error occurs
     * @throws RepositoryException if a repository error occurs
     */
    JSONResponse uploadPackage(File file, String name, ProxyTracker tracker, String group)
            throws IOException, RepositoryException;

}
