/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

import javax.jcr.Binary;
import javax.servlet.http.HttpServletRequest;

import org.apache.http.Header;
import org.apache.http.auth.Credentials;

/**
 * <code>Proxy</code>...
 */
public interface Proxy {

    ProxyTracker getTracker();

    void setTracker(ProxyTracker tracker);

    void setContextPath(String path);

    void setIdString(String id);

    /**
     * Adds an extra parameter to the request
     * @param name parameter name
     * @param value parameter value
     */
    void addExtraParameter(String name, String value);

    /**
     * Adds an extra header to the request
     * @param name header name
     * @param value header value
     */
    void addExtraHeader(String name, String value);

    /**
     * Adds extra parameters from  the request
     * @param request servlet request
     */
    void addExtraParameters(HttpServletRequest request);

    void addExtraFile(String name, File file) throws FileNotFoundException;

    void addExtraFile(String name, File file, String fileName) throws FileNotFoundException;

    void addExtraFile(String name, Binary data, String fileName) throws FileNotFoundException;

    boolean isIgnoreTypeAttribute();

    void setIgnoreTypeAttribute(boolean ignoreTypeAttribute);

    /**
     * Set writer to use when appending new content.
     * @param writer print writer
     */
    void setWriter(PrintWriter writer);

    /**
     * Rewrite a (possible relative) URL.
     * @param url url to rewrite
     * @param spool if true, the spool path is used
     * @return rewritten URL
     */
    String rewriteURL(String url, boolean spool);

    Credentials getCredentials();

    void setCredentials(Credentials credentials);

    int doGet(String path) throws IOException;

    int doPost(String path) throws IOException;

    void close();

    boolean isHtml();

    String getContentType();

    String getLastModified();

    void setLastModified(String lastModified);

    long getContentLength();

    String getLocation(boolean rewrite, boolean spool);

    Header getResponseHeader(String name);

    String getResponseHeaderValue(String name);

    void rewrite(Writer writer) throws IOException;

    int spool(OutputStream out) throws IOException;

    void spoolCss(Writer out) throws IOException;

    String fetch() throws IOException;

    void setFollowRedirects(boolean followRedirects);

}
