/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging;

import java.io.IOException;
import java.io.InputStream;

/**
 * <code>TrackingInputStream</code>...
 */
public class TrackingInputStream extends InputStream {

    private final InputStream base;

    private final long length;

    private long count = 0;

    private final ProxyTracker tracker;

    public TrackingInputStream(InputStream base, long length, ProxyTracker tracker) {
        this.base = base;
        this.length = length;
        this.tracker = tracker;
    }

    public int read(byte[] bytes) throws IOException {
        int ret = base.read(bytes);
        if (ret >= 0) {
            count+= ret;
            tracker.onProgress(count, length);
        }
        return ret;
    }

    public int read(byte[] bytes, int i, int i1) throws IOException {
        int ret = base.read(bytes, i, i1);
        if (ret >= 0) {
            count+= ret;
            tracker.onProgress(count, length);
        }
        return ret;
    }

    public int read() throws IOException {
        int ret = base.read();
        if (ret >= 0) {
            tracker.onProgress(count++, length);
        }
        return ret;
    }

    public long skip(long l) throws IOException {
        long ret = base.skip(l);
        if (ret >= 0) {
            count+= ret;
            tracker.onProgress(count, length);
        }
        return ret;
    }
}