/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging.gfx;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;

import javax.jcr.RepositoryException;

import com.day.image.Layer;

/**
 * <code>GfxHelper</code>...
 */
public class GfxHelper {

    /**
     * location of the alpha mask for thumbnails
     */
    static final String GFX_MASK_ALPHA_PATH =  "com/day/crx/packaging/mask.gif";

    /**
     * location of the glare mask for thumbnails
     */
    static final String GFX_MASK_GLARE_PATH = "com/day/crx/packaging/mask.png";


    public static Layer stampThumbnail(ImageResource image) throws IOException, RepositoryException {
        if (!image.hasContent()) {
            return null;
        }
        // get pure layer
        Layer layer = image.getLayer(false, false, false);

        // crop
        image.crop(layer);

        // resize
        int w = layer.getWidth();
        int h = layer.getHeight();
        if (h < w) {
            image.set(ImageResource.PN_HEIGHT, "64");
        } else {
            image.set(ImageResource.PN_WIDTH, "64");
        }
        image.resize(layer);

        // crop again
        layer.crop(new Rectangle(0, 0, 64, 64));

        // rotate
        image.rotate(layer);


        // merge alpha channel with layer mask
        Layer alpha = ImageHelper.createLayer(DownloadResource.class.getClassLoader(), GFX_MASK_ALPHA_PATH);
        Layer alpha2 = new Layer(layer.getWidth(), layer.getHeight(), Color.WHITE);
        alpha2.copyChannel(layer, Layer.ALPHA_CHANNEL_ID, Layer.RED_CHANNEL_ID);
        alpha2.copyChannel(alpha, Layer.RED_CHANNEL_ID, Layer.ALPHA_CHANNEL_ID);
        alpha2.flatten(Color.BLACK);

        // apply new alpha channel to layer
        layer.copyChannel(alpha2, Layer.RED_CHANNEL_ID, Layer.ALPHA_CHANNEL_ID);

        // and merge with 'glare' image
        Layer mask = ImageHelper.createLayer(DownloadResource.class.getClassLoader(), GFX_MASK_GLARE_PATH);
        layer.merge(mask);
        return layer;
    }

    public static Layer stampScreenshot(ImageResource image)
            throws IOException, RepositoryException {
        return stampScreenshot(image, false);
    }

    public static Layer stampScreenshot(ImageResource image, boolean notNull)
            throws IOException, RepositoryException {
        if (!image.hasContent()) {
            return null;
        }

        // get pure layer
        Layer layer = image.getLayer(false, false, false);
        boolean modified = false;

        if (layer != null) {
            // crop
            modified = image.crop(layer) != null;

            // resize
            modified |= image.resize(layer) != null;

            // rotate
            modified |= image.rotate(layer) != null;

        }

        if (modified || notNull) {
            return layer;
        }
        return null;
    }


}