/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2017 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.packaging.validation;

import java.util.jar.JarInputStream;

import org.osgi.framework.Bundle;

import com.day.crx.packaging.validation.impl.BundleData;

/**
 * <code>BundlePackagesParser</code>
 * Parses the import and export packages of a bundle into a list of packages and their versions.
 */
public interface BundlePackagesParser {

    /**
     * Given input stream of a bundle, parses the import and export packages string 
     * present in the manifest of the bundle.
     * Returns null if not an osgi bundle i.e. no manifest.
     * @param jarStream - Jar Input Stream of the bundle
     * @return - Parsed Bundle Data
     */
    BundleData getBundleData(JarInputStream jarStream);
    
    /**
     * Given an osgi bundle, parses the import and export packages string 
     * present in the manifest of the bundle.
     * @param bundle - OSGI Bundle
     * @return Parsed Bundle Data
     */
    BundleData getBundleData(Bundle bundle);
}
