/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.crx.sling.server.jmx;

import java.util.ArrayList;
import java.util.List;

import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

import com.adobe.granite.jmx.annotation.OpenTypeUtils;
import com.adobe.granite.jmx.annotation.TabularTypeInfo;
import com.day.crx.core.cluster.ClusterNodeInfo;

/**
 * A convenient adapter to generate JMX {@link TabularData} where it's row type
 * is {@link ClusterNodeInfo}.
 */
@TabularTypeInfo(rowType = ClusterNodeInfo.class, indexNames = "id")
public class ClusterNodeInfoTabular {

    private List<ClusterNodeInfo> nodes = new ArrayList<ClusterNodeInfo>();

    public void add(ClusterNodeInfo node) {
        nodes.add(node);
    }

    public TabularData toTabularData() {
        try {
            TabularType type = OpenTypeUtils.createTabularType(this.getClass());
            TabularDataSupport tabular = new TabularDataSupport(type);

            CompositeType itemType = OpenTypeUtils.createCompositeType(ClusterNodeInfo.class);
            String[] itemNames = new String[] { "id", "OS", "hostname",
                "repositoryHome" };

            for (ClusterNodeInfo node : nodes) {
                Object[] itemValues = new Object[] { node.getId(),
                    node.getOS(), node.getHostname(), node.getRepositoryHome() };

                tabular.put(new CompositeDataSupport(itemType, itemNames,
                    itemValues));
            }

            return tabular;
        } catch (OpenDataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}
