/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.crx.sling.server.jmx;

import javax.jcr.RepositoryException;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.TabularData;

import com.adobe.granite.jmx.annotation.Description;
import com.adobe.granite.jmx.annotation.Impact;
import com.adobe.granite.jmx.annotation.Name;
import com.adobe.granite.jmx.annotation.OpenTypeInfo;

@Description("CRX Repository")
public interface ManagedRepositoryMBean {

    @Description("The name of the repository")
    String getName();

    @Description("The version of the repository")
    String getVersion();

    @Description("The name of the customer the repository is licensed to")
    String getCustomerName();

    String getLicenseKey();

    String getHomeDir();

    Long getAvailableDiskSpace();

    Integer getMaximumNumberOfOpenFiles();

    Boolean getSessionTracker();

    void setSessionTracker(Boolean debug);

    @OpenTypeInfo(SimpleMap.class)
    @Description("The repository descriptors")
    TabularData getDescriptors();

    @Description("The workspaces currently available in the repository")
    String[] getWorkspaceNames();

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Create a new workspace with the give name.")
    void createWorkspace(
            @Name("name")
            @Description("The name of the new workspace")
            String name) throws RepositoryException;

    //----------------------------------------------------< Datastore >

    @Description("Number of milliseconds to sleep after each ten nodes scanned")
    Integer getDataStoreGarbageCollectionDelay();

    void setDataStoreGarbageCollectionDelay(Integer delay);

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Runs data store garbage collection")
    void runDataStoreGarbageCollection(
            @Name("delete")
            @Description("Flag to delete all collected garbage")
            Boolean delete) throws RepositoryException;

    //------------------------------------------------------< Backup >

    @Description("The extra delay (in milliseconds) added between steps of the backup process")
    Integer getBackupDelay();

    void setBackupDelay(Integer delay);

    @Description("Is a backup currently in progress?")
    Boolean getBackupInProgress();

    @Description("Progress of the currently running backup process")
    Integer getBackupProgress();

    @Description("The path of the currently running backup process")
    String getCurrentBackupTarget();

    @Description("Was the last backup successful?")
    Boolean getBackupWasSuccessful();

    @Description("The status message of the last backup")
    String getBackupResult();

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Starts the repository backup process")
    void startBackup(
            @Name("target")
            @Description("Optional target directory or file (with .zip extension)")
            String target) throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Starts the repository backup process")
    void startBackup(
            @Name("installDir")
            @Description("Optional CRX installation directory")
            String installDir,
            @Name("target")
            @Description("Optional target directory or file (with .zip extension)")
            String target) throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Cancels the current backup process")
    void cancelBackup();

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Blocks all repository writes")
    void blockRepositoryWrites() throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Unblocks all repository writes")
    void unblockRepositoryWrites() throws RepositoryException;

    //------------------------------------------------------< Tar PM >

    @Description("The timestamp of when Tar PM optimization was started, or 0 if it's currently not running")
    Long getTarOptimizationRunningSince();

    @Description("Number of milliseconds to sleep after optimizing one transaction")
    Integer getTarOptimizationDelay();

    void setTarOptimizationDelay(Integer delay);

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Start Tar PM optimization")
    void startTarOptimization() throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Stop Tar PM optimization")
    void stopTarOptimization() throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Tar PM index merge may improve the Tar PM performance")
    void tarIndexMerge(
            @Name("background")
            @Description("Merge in the background")
            Boolean background)
            throws RepositoryException;

    //------------------------------------------------------< Clustering >

    @OpenTypeInfo(SimpleMap.class)
    @Description("Cluster properties")
    TabularData getClusterProperties();

    @OpenTypeInfo(ClusterNodeInfoTabular.class)
    @Description("The identifiers and hostnames of all cluster nodes")
    TabularData getClusterNodes();

    @Description("Identifier of this cluster")
    String getClusterId();

    @Description("Identifier of the master node")
    String getClusterMasterId();

    @Description("Identifier of this cluster node")
    String getClusterNodeId();

    @Description("The instance revision of this cluster node")
    Long getClusterNodeRevision();

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Turns this node into the master of the cluster")
    void becomeClusterMaster() throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Turns this repository into a slave of the given cluster")
    void joinCluster(
            @Name("master")
            @Description("URL of the cluster master")
            String master,
            @Name("username")
            @Description("Username of a cluster administrator")
            String username,
            @Name("password")
            @Description("Password of a cluster administrator")
            String password) throws Exception;

    //------------------------------------------------------< Repository Check >

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Traverses the structure of the repository")
    String traversalCheck(
            @Name("rootNode")
            @Description("The start path")
            String rootNodeName, 
            @Name("logEach")
            @Description("Log each node")
            Boolean logEach, 
            @Name("fixInconsistencies")
            @Description("Fixes inconsistencies automatically")
            Boolean fixInconsistencies);

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Finds inconsistent nodes")
    String consistencyCheck(
            @Name("rootNode")
            @Description("The start path")
            String rootNodeName, 
            @Name("fixInconsistencies")
            @Description("Fixes inconsistencies automatically")
            Boolean fixInconsistencies);

    //------------------------------------------------------< OAK >

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Restores the current state to the provided source, only works on the Tar NodeStore")
    void nodeStoreRestore(
            @Name("Source")
            @Description("Reference directory for the restore operation")
            String sourceDirectory)
            throws RepositoryException;

    @Impact(MBeanOperationInfo.ACTION)
    @Description("Creates a new checkpoint of the latest root of the tree.")
    String checkpoint(
            @Name("lifetime") @Description("lifetime time (in milliseconds, > 0) that the checkpoint should remain available") Long lifetime);

}
