/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.crx.sling.server.jmx;

import java.util.TreeMap;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

import com.adobe.granite.jmx.annotation.OpenTypeUtils;
import com.adobe.granite.jmx.annotation.TabularTypeInfo;

/**
 * A convenient adapter to generate JMX {@link TabularData} for
 * java.util.Map<String, String>.
 */
@SuppressWarnings("serial")
@TabularTypeInfo(rowType = SimpleMap.Entry.class, indexNames = "key")
public class SimpleMap extends TreeMap<String, String> {

    public SimpleMap() {
    }

    public SimpleMap(TabularData tabular) {
        if (!SimpleMap.Entry.class.getName().equals(
            tabular.getTabularType().getRowType().getTypeName())) {
            throw new IllegalArgumentException(
                "Incompatible tabular data. Accepting "
                    + SimpleMap.Entry.class.getName());
        }

        for (Object entry : tabular.values()) {
            CompositeData e = (CompositeData) entry;
            put(e.get("key").toString(), e.get("value").toString());
        }
    }

    public TabularData toTabularData() {
        try {
            TabularType type = OpenTypeUtils.createTabularType(this.getClass());
            TabularDataSupport tabular = new TabularDataSupport(type);

            CompositeType itemType = OpenTypeUtils.createCompositeType(SimpleMap.Entry.class);
            String[] itemNames = new String[] { "key", "value" };

            for (java.util.Map.Entry<String, String> e : entrySet()) {
                Object[] itemValues = new Object[] { e.getKey(), e.getValue() };

                tabular.put(new CompositeDataSupport(itemType, itemNames,
                    itemValues));
            }

            return tabular;
        } catch (OpenDataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public interface Entry {
        String getKey();

        String getValue();
    }
}
