/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.durbo;

/**
 * The DurboConstants interface defines some constants for the <code>Durbo</code>
 * protocol.
 */
public interface DurboConstants {

    /**
     * defines the property type identifier byte
     */
    static final byte PROPERTY = 0x10;

    /**
     * defines the property type identifier byte
     */
    static final byte PROPERTY_TYPE_MASK = 0xf;

    /**
     * defines the node type identifier byte
     */
    static final byte NODE_START = 0x20;

    /**
     * defines the namespace  element
     */
    static final byte NAMESPACE = 0x21;

    /**
     * defines the node end type identifier byte
     */
    static final byte NODE_END = 0x2f;

    /**
     * defines the the property is multiple
     */
    static final byte MULTIPLE = 0x40;

    /**
     * defines the protocol header name
     */
    static final String PROTOCOL_HEADER = "DurboSer";

    /**
     * defines the protocol header name
     */
    static final String PROTOCOL_ENCODING = "Encoding";

    /**
     * defines the protocol header name
     */
    static final String PROTOCOL_CONTENT_TYPE = "ContentType";

    /**
     * defines the protocol header name
     */
    static final String DEFAULT_CONTENT_TYPE = "durboser/unstructured";

    /**
     * 1.0 version
     */
    static final double PROTOCOL_VERSION_1 = 1.0;

    /**
     * 2.0 version
     */
    static final double PROTOCOL_VERSION_2 = 2.0;

    /**
     * 2.1 version.
     * Note that this version is not used internally but by external applications like the old CQ3 content packages.
     */
    static final double PROTOCOL_VERSION_2_1 = 2.1;

    /**
     * defines the protocol version
     */
    static final double PROTOCOL_VERSION = PROTOCOL_VERSION_2_1;

}
