/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.durbo;

import javax.jcr.NamespaceException;

/**
 * This Interface defines a namespace resolver.
 */
public interface DurboNamespaceResolver {

    /**
     * Returns the URI to which the given prefix is mapped.
     *
     * @param prefix a string
     * @return the namespace URI to which the given prefix is mapped.
     * @throws javax.jcr.NamespaceException if the prefix is unknown.
     */
    public String getURI(String prefix) throws NamespaceException;

    /**
     * Returns the prefix which is mapped to the given URI.
     *
     * @param uri a string
     * @return the prefix mapped to the given URI.
     * @throws NamespaceException if the URI is unknown.
     */
    public String getPrefix(String uri) throws NamespaceException;

}
