/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.durbo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.jcr.PropertyType;

/**
 * This Class implements some durbo utilities.
 */
public class DurboUtil {

    /**
     * some blanks for indentation
     */
    private static final String BLANKS = "                                           " +
            "                                                                        ";


    /**
     * Dumps the contents of the durbo input in a generic way
     *
     * @param in durbo input stream
     * @param out print writer to dump to
     * @throws IOException if an I/O error occurs
     */
    private static void dump(DurboInput in, PrintWriter out) throws IOException {
        int indent = 0;
        DurboInput.Element elem;
        out.println("DurboSer: Version " + in.getVersion());
        out.println("Encoding: " + in.getEncoding());
        out.println("ContentType: " + in.getContentType());
        while ((elem = in.read()) != null) {
            if (elem.isProperty()) {
                DurboInput.Property p = (DurboInput.Property) elem;
                out.print(BLANKS.substring(0, indent));
                out.print(p.name());
                String delim = ": ";
                DurboValue[] values = p.getValues();
                for (DurboValue value : values) {
                    out.print(delim);
                    if (p.getType() == PropertyType.BINARY) {
                        out.print("<binary, size=" + value.getLength() + ">");
                    } else {
                        out.print(value.getString());
                    }
                    delim = ", ";
                }
                out.print("  (");
                out.print(PropertyType.nameFromValue(p.getType()));
                if (p.isMultiple()) {
                    out.println("[])");
                } else {
                    out.println(")");
                }

            } else if (elem.isNodeStart()) {
                out.print(BLANKS.substring(0, indent));
                out.println(elem.name());
                indent += 2;
                out.print(BLANKS.substring(0, indent));
                out.println("{");
            } else if (elem.isNodeEnd()) {
                out.print(BLANKS.substring(0, indent));
                out.println("}");
                indent -= 2;
            }
        }
        // print defined namespaces
        out.println("used namespaces:");
        String[] nsp = in.getPrefixes();
        for (String aNsp : nsp) {
            out.println("  " + aNsp + ":" + in.getURI(aNsp));
        }
    }

    /**
     * Dumps the contents of the indicated package generically
     *
     * @param args the file to dump
     */
    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream(args[0]);
            DurboInput din = new DurboInput(in);
            dump(din, new PrintWriter(System.out, true));
            in.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
