/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.durbo;

import javax.jcr.NamespaceException;

/**
 * Implements a {@link DurboNamespaceResolver} that maps prefixes to the same
 * value as the uris and vice versa.
 */
public class IdentityNamespaceResolver implements DurboNamespaceResolver {

    /**
     * {@inheritDoc}
     *
     * @return the same as <code>prefix</code>
     */
    public String getURI(String prefix) throws NamespaceException {
        return prefix;
    }

    /**
     * {@inheritDoc}
     *
     * @return the same as <code>uri</code>
     */
    public String getPrefix(String uri) throws NamespaceException {
        return uri;
    }
}