/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.io;

import java.io.OutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

/**
 * <code>ChunkedDeflaterOutputStream</code> extends a {@link DeflaterOutputStream}
 * than can be restarted. when the stream is restarted the compression
 * is finished and the internal deflater is reset. this means that the
 * underlying output stream can consist of several overlayed compressed
 * chunks. an {@link InflaterInputStream} would signal EOF when the end of
 * such a chunk is reached altough the underlying stream is not finished. use
 * {@link ChunkedInflaterInputStream} or the {@link RegionFileInputStream} which
 * can deal with such streams.
 *
 * @author tripod
 * @version $Rev$, $Date$
 */
public class ChunkedDeflaterOutputStream extends DeflaterOutputStream {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    private long autoRestart = Long.MAX_VALUE;

    public ChunkedDeflaterOutputStream(OutputStream out) {
        super(out);
    }

    public ChunkedDeflaterOutputStream(OutputStream out, Deflater def) {
        super(out, def);
    }

    public ChunkedDeflaterOutputStream(OutputStream out, Deflater def, int size) {
        super(out, def, size);
    }

    /**
     * Restarts the compression. i.e. flushes all compressed data and resets
     * the deflater.
     *
     * @return the number of bytes that were transfered to the underlying
     * stream.
     *
     * @throws IOException
     */
    public long restart() throws IOException {
        finish();
        long ret = def.getTotalOut();
        def.reset();
        return ret;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (def.getTotalOut() > autoRestart) {
            restart();
        }
    }

    /**
     * Sets the number of written bytes after which the compression should be
     * restarted.
     *
     * @param len
     */
    public void setAutoRestart(long len) {
        autoRestart = len;
    }
}