/*
 * $Id: DebugFileInputStream.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.io;

import java.io.*;
import java.util.Iterator;

/**
 * The <code>DebugFileInputStream</code> class implements...
 *
 * @version $Revision: 1.3 $
 * @author tripod
 * @since coati
 */
public class DebugFileInputStream extends FileInputStream {
    private static java.util.HashSet inputs = new java.util.HashSet();
    public static void dumpRegistered(PrintWriter out) {
	synchronized (inputs) {
	    Iterator iter = inputs.iterator();
	    while (iter.hasNext()) {
		DebugFileInputStream in = (DebugFileInputStream) iter.next();
		in.dump(out);
	    }
	}
    }
    public static void dumpRegistered(PrintStream out) {
	synchronized (inputs) {
	    Iterator iter = inputs.iterator();
	    while (iter.hasNext()) {
		DebugFileInputStream in = (DebugFileInputStream) iter.next();
		in.dump(out);
	    }
	}
    }
    private final File file;
    private boolean closed = false;
    private Throwable location = null;

    public DebugFileInputStream(String name) throws FileNotFoundException {
	this(new File(name));
    }

    public DebugFileInputStream(File file) throws FileNotFoundException {
	super(file);
	this.file = file;
	try {
	    throw new Throwable();
	} catch (Throwable t) {
	    this.location= t;
	}
	synchronized (inputs) {
	    inputs.add(this);
	}
    }

    public void close() throws IOException {
	this.closed=true;
	super.close();
    }
    public void dump(PrintWriter out) {
	out.println("path="+file.getPath()+" closed="+closed);
	if (!closed) {
	    location.printStackTrace(out);
	}
    }
    public void dump(PrintStream out) {
	out.println("path="+file.getPath()+" closed="+closed);
	if (!closed) {
	    location.printStackTrace(out);
	}
    }
}
