/**
 * $Id: SizedBlankInputStream.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 *
 * @version $Revision: 1.8 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 */

package com.day.io.file;



/**
 *
 * An InputStream of a predetermined length - of which all the characters are the same value.
 * This is to use while testing memory usage.
 *
 * @version $Revision: 1.8 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author InigoSurguy
 * @since antbear
 */
public class SizedBlankInputStream extends SizedInputStream {

    public SizedBlankInputStream(int length) {
	this(length, (byte) 0);
    }

    public SizedBlankInputStream(int length, byte value) {
	super(new SingleValueInputStream(value), length);
    }

}


