/**
 * $Id: StreamUtils.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 *
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 */

/**
 * $Id: StreamUtils.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 *
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 */

 package com.day.io.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Utility methods for dealing with Streams.
 * <p>
 * Some of the buffer methods here could be rewritten using the ByteArrayOutputStream - this is a JDK class that
 * does a lot of what we want, in a more optimized way than we currently have.
 */
public class StreamUtils {

    private static final Logger log =
        LoggerFactory.getLogger(StreamUtils.class);

    public static String convertStreamToString(InputStream in) throws IOException {
        log.debug("Starting convertStreamToString ("+""+"in : "+in + " , "+")");
        return new String(readBytesFromStream(in));
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        log.debug("Starting readBytesFromStream ("+""+"in : "+in + " , "+")");
        int bytesread = 0;
        byte[] readBuffer = new byte[4096];
        byte[] content = new byte[0];
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            // Append the new content to the existing, and loop
            content = append(content, readBuffer, bytesread);
        }
        in.close();

        return content;
    }

    public static void pipeInputToOutput(InputStream in, OutputStream out) throws IOException {
        byte[] readBuffer = new byte[4096];
        int bytesread = 0;
	while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
	    out.write(readBuffer, 0, bytesread);
        }
        in.close();
	out.flush();
	out.close();
    }

    /**
     * @todo This could be faster with buffering - the reason that it's not being used is that adding buffering
     * 		introduces complications - what if 1k is read from one stream, but 2k from the other? This is
     * 		perfectly valid for two identical streams, but makes it harder to check them against each other.
     * 		Until it's used outside test code, there's no point in optimizing it.
     */
    public static boolean areStreamsIdentical(InputStream first, InputStream second) throws IOException {
	boolean streamsAreIdentical = true;
        while (true) {
	    final int readFromFirst = first.read();
	    final int readFromSecond = second.read();
	    if (readFromFirst!=readFromSecond) {
		streamsAreIdentical = false;
		break;
	    }
	    if (readFromFirst==-1) { break; }
        }
        first.close();
	second.close();
	return streamsAreIdentical;
    }

    public static String readStringFromReader(Reader in) throws IOException {

        int bytesread = 0;
        char[] readBuffer = new char[4096];
        char[] content = new char[0];
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            // Append the new content to the existing, and loop
            content = append(content, readBuffer, bytesread);
        }
        in.close();

        return new String(content);
    }

    public static String readStringFromReaderDontClose(Reader in) throws IOException {

        int bytesread = 0;
        char[] readBuffer = new char[4096];
        char[] content = new char[0];
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            // Append the new content to the existing, and loop
            content = append(content, readBuffer, bytesread);
        }
        return new String(content);
    }


    public static InputStream convertStringToStream(String astring) {
        log.debug("Starting convertStringToStream ("+""+"astring : "+astring + " , "+")");
        return new ByteArrayInputStream(astring.getBytes());
    }

    public static byte[] append(byte[] source, byte[] addition, int length) {
        log.debug("Starting append ("+""+"source : "+source + " , "+"addition : "+addition + " , "+"length : "+length + " , "+")");
        byte[] dest = new byte[source.length + length];
        System.arraycopy(source, 0, dest, 0, source.length);
        System.arraycopy(addition, 0, dest, source.length, length);
        return dest;
    }

    public static char[] append(char[] source, char[] addition, int length) {
        log.debug("Starting append ("+""+"source : "+source + " , "+"addition : "+addition + " , "+"length : "+length + " , "+")");
        char[] dest = new char[source.length + length];
        System.arraycopy(source, 0, dest, 0, source.length);
        System.arraycopy(addition, 0, dest, source.length, length);
        return dest;
    }

    /**
     * @todo [MINOR] Maybe this should be in a different class?
     */
    public static String loadFromURL(String urlReference) throws IOException {
        URL pageURL = new URL(urlReference);
        URLConnection openConnection = pageURL.openConnection();
        openConnection.connect();

        InputStream input = openConnection.getInputStream();
        StringBuffer buf = new StringBuffer();
        int c;
        while ((c = input.read()) >= 0) {
            buf.append((char) c);
        }
        input.close();

        return buf.toString();
    }
}

