/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.jcr.RepositoryException;

import com.day.jcr.vault.fs.api.AccessType;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ExportArtifact;
import com.day.jcr.vault.fs.api.ImportArtifact;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;

/**
 * Implements a generic directory artifact.
 *
 */
public class DirectoryArtifact implements ExportArtifact, ImportArtifact {

    /**
     * Constructs a new directory type artifact with the given repository name.
     *
     * @param name the repository name for this artifact.
     */
    public DirectoryArtifact(String name) {
        throw new UnsupportedOperationException("No longer supported. use the org.apache.jackrabbit.vault counterpart.");
    }

    /**
     * Constructs a new directory type artifact with the given repository name
     * and extension
     *
     * @param name the repository name for this artifact.
     * @param extension the extension for this artifact
     */
    public DirectoryArtifact(String name, String extension) {
        throw new UnsupportedOperationException("No longer supported. use the org.apache.jackrabbit.vault counterpart.");
    }

    /**
     * {@inheritDoc}
     */
    public SerializationType getSerializationType() {
        return SerializationType.NONE;
    }

    /**
     * {@inheritDoc}
     *
     * @return always {@link AccessType#NONE}
     */
    public AccessType getPreferredAccess() {
        return AccessType.NONE;
    }

    /**
     * {@inheritDoc}
     */
    public void spool(OutputStream out) throws IOException, RepositoryException {
        throw new UnsupportedOperationException("Illegall access method for " + this);
    }

    /**
     * {@inheritDoc}
     */
    public InputStream getInputStream() throws IOException, RepositoryException {
        throw new UnsupportedOperationException("Illegall access method for " + this);
    }

    /**
     * {@inheritDoc}
     */
    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        throw new UnsupportedOperationException("Illegall access method for " + this);
    }

    /**
     * {@inheritDoc}
     */
    public long getContentLength() {
        return -1;
    }

    /**
     * {@inheritDoc}
     */
    public long getLastModified() {
        return 0;
    }

    public String getPlatformPath() {
        return null;
    }

    public String getExtension() {
        return null;
    }

    public String getRelativePath() {
        return null;
    }

    public ArtifactType getType() {
        return null;
    }

    public String getContentType() {
        return null;
    }

    public void dump(DumpContext ctx, boolean isLast) {
    }
}