/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs;

import java.io.IOException;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import com.day.jcr.vault.fs.api.RepositoryAddress;
import com.day.jcr.vault.fs.api.VaultFileSystem;
import com.day.jcr.vault.fs.api.VaultFsConfig;
import com.day.jcr.vault.fs.api.WorkspaceFilter;

/**
 * Utility method to mount a JCR FS.
 * The filesystem is mounted relative to the given <code>mountpoint</code> and rooted at <code>rootPath</code>.
 * For example if the mountpoint is http://.../test/export and the rootPath is /foo, then the filesystem's root node
 * has a internal repository path "/foo" that corresponds to the "real" repository node at "/test/export".
 * The workspace filter will be matched against the filesystem paths (e.g. /foo).
 */
public final class Mounter {

    /**
     * Mounts a new Vault filesystem on the given repository node.
     *
     * @param config vault fs config
     * @param wspFilter the workspace filter
     * @param mountpoint the address of the mountpoint
     * @param rootPath path of root file. used for remapping
     * @param session the repository session
     * @return a Vault filesystem
     * @throws RepositoryException if an error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public static VaultFileSystem mount(VaultFsConfig config,
                                      WorkspaceFilter wspFilter,
                                      RepositoryAddress mountpoint,
                                      String rootPath,
                                      Session session)
            throws RepositoryException, IOException {
        throw new UnsupportedOperationException("Mounter is not longer supported. use the org.apache.jackrabbit.filevault counterpart.");
    }

    /**
     * Mounts a new Vault filesystem that is rooted at the given path using
     * the provided repository, credentials and workspace to create the
     * session.
     *
     * @param config vault fs config
     * @param wspFilter the workspace filter
     * @param rep the jcr repository
     * @param credentials the credentials
     * @param mountpoint the repository address of the mountpoint
     * @param rootPath path of root file. used for remapping
     * @return an aggregate manager
     * @throws RepositoryException if an error occurs.
     * @throws IOException if an I/O error occurs.
     */
    public static VaultFileSystem mount(VaultFsConfig config,
                                      WorkspaceFilter wspFilter,
                                      Repository rep,
                                      Credentials credentials,
                                      RepositoryAddress mountpoint,
                                      String rootPath)
    throws RepositoryException, IOException {
        throw new UnsupportedOperationException("Mounter is not longer supported. use the org.apache.jackrabbit.filevault counterpart.");
    }


}