/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.util.Collection;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

/**
 * <code>Aggregate</code>...
 */
public interface Aggregate extends Dumpable {

    Node getNode() throws RepositoryException;

    boolean hasNode() throws RepositoryException;

    Aggregate getParent();

    String getPath();

    /**
     * Returns the (absolute) repository address to the node that this artifact
     * node represents.
     *
     * @return the repository address
     * @throws RepositoryException if an error occurs.
     */
    RepositoryAddress getRepositoryAddress() throws RepositoryException;

    /**
     * Checks if this artifact node possibly allows children, i.e. is a folder.
     *
     * @return <code>true</code> if this artifact node allows children;
     *         <code>false</code> otherwise.
     */
    boolean allowsChildren();

    /**
     * Returns the relative path of this aggregate in respect to it's parent
     * aggregate.
     *
     * @return the relative path
     */
    String getRelPath();

    /**
     * Returns the name of this aggregate.
     * @return the name of this aggregate.
     */
    String getName();

    /**
     * Returns the leaves of this aggregate or <code>null</code>.
     * @return the leaves
     * @throws RepositoryException if an error occurs
     */
    List<? extends Aggregate> getLeaves() throws RepositoryException;

    Aggregate getAggregate(String relPath) throws RepositoryException;

    /**
     * Returns the artifacts of this node.
     *
     * @return the artifacts
     * @throws RepositoryException if this file is not attached to the fs, yet.
     */
    ArtifactSet getArtifacts() throws RepositoryException;

    /**
     * Returns the artifact manager this node belongs to.
     * @return the Vault filesystem.
     */
    AggregateManager getManager();

    /**
     * Checks if this aggregate has an aggregator and its node exists.
     * @return <code>true</code> if this aggregate is attached
     * @throws RepositoryException if an error occurs
     */
    boolean isAttached() throws RepositoryException;

    String[] getNamespacePrefixes();

    String getNamespaceURI(String prefix) throws RepositoryException;

    /**
     * Returns the collection of binary properties in this aggregate
     * @return the binaries or <code>null</code>
     */
    Collection<Property> getBinaries();
}