/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.io.IOException;
import java.io.PrintWriter;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * <code>AggregateManager</code>...
 */
public interface AggregateManager extends NodeTypesCollector {
    /**
     * Releases all resources attached to this artifact manager
     * @throws RepositoryException if an error occurs.
     */
    void unmount() throws RepositoryException;

    /**
     * Returns the root aggregate of the tree
     * @return the root aggregate.
     * @throws RepositoryException if an error occurs.
     */
    Aggregate getRoot() throws RepositoryException;

    /**
     * Returns the repository address of the mountpoint of this artifacts node
     * tree.
     * @return the mountpoint
     */
    RepositoryAddress getMountpoint();

    /**
     * Returns the aggregator for the given node or <code>null</code> if none
     * found.
     * @param node for which the aggregator is to be returned
     * @param path the path of the node or <code>null</code>
     * @return the aggregator or <code>null</code>
     * @throws RepositoryException if a repository error occurs.
     */
    Aggregator getAggregator(Node node, String path) throws RepositoryException;

    /**
     * Returns the workspace filter.
     * @return the workspace filter.
     */
    WorkspaceFilter getWorkspaceFilter();

    /**
     * Checks if this tree is still mounted and if the attached session
     * is still live.
     *
     * @return <code>true</code> if still mounted
     */
    boolean isMounted();

    /**
     * Returns the user id of the session of this manager.
     * @return the user id.
     * @throws RepositoryException if an error occurs.
     */
    String getUserId() throws RepositoryException;

    /**
     * Returns the name of the workspace of this manager.
     * @return the name of the workspace.
     * @throws RepositoryException if an error occurs.
     */
    String getWorkspace() throws RepositoryException;

    /**
     * Returns the session of this manager.
     * @return the jcr session
     */
    Session getSession();

    /**
     * Returns the config
     * @return the config
     */
    VaultFsConfig getConfig();

    /**
     * Dumps the configuration to the given writer for debugging purposes.
     * @param out the writer
     * @throws IOException if an I/O error occurs
     */
    void dumpConfig(PrintWriter out) throws IOException;

    /**
     * Starts tracking aggregate lifecycles
     * @param listener optional listener
     */
    public void startTracking(ProgressTrackerListener listener);

    /**
     * Stops tracking of aggregate lifecycle
     */
    public void stopTracking();


}