/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.io.IOException;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * <code>ArtifactHandler</code>s are used to import artifacts into the
 * jcr repository.
 *
 */
public interface ArtifactHandler extends Dumpable {

    /**
     * Imports an artifact set for the given node.
     *
     * @param session the session to use for import
     * @param aggregate the aggregate
     * @param artifacts the artifacts to import
     * @return the import info on successful import, <code>null</code> otherwise
     * @throws RepositoryException if an error occurs.
     * @throws IOException if a I/O error occurs
     */
    ImportInfo accept(Session session, Aggregate aggregate, ArtifactSet artifacts)
            throws RepositoryException, IOException;

    /**
     * Imports an artifact set as new child node for the given parent.
     *
     * @param session the session to use for import
     * @param parent the parent aggregate of the new file to import
     * @param name the name of the new node
     * @param artifacts the artifacts to import
     * @return the import info on successful import, <code>null</code> otherwise
     * @throws RepositoryException if an error occurs.
     * @throws IOException if a I/O error occurs
     */
    ImportInfo accept(Session session, Aggregate parent, String name,
                      ArtifactSet artifacts)
            throws RepositoryException, IOException;
}