/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.util.Collection;

/**
 * <code>ArtifactSet</code>...
 */
public interface ArtifactSet extends Dumpable {
    
    /**
     * Returns the item filter set that defines the coverage of the items in
     * this artifact set.
     * @return the item filter set.
     */
    ItemFilterSet getCoverage();

    /**
     * Adds a collection of artifacts
     *
     * @param artifacts the artifacts collection
     */
    void addAll(Collection<? extends Artifact> artifacts);

    /**
     * Adds a set of artifacts
    *
    * @param artifacts the artifacts set
    */
    void addAll(ArtifactSet artifacts);

    /**
     * Adds an artifacts
     *
     * @param artifact the artifact to add
     * @throws IllegalArgumentException if more than 1 primary data artifact is added
     */
    void add(Artifact artifact);

    /**
     * Returns the primary data artifact or <code>null</code>.
     * @return the primary data artifact or <code>null</code>.
     */
    Artifact getPrimaryData();

    /**
     * Returns the directory artifact or <code>null</code>.
     * @return the directory artifact or <code>null</code>.
     */
    Artifact getDirectory();

    /**
     * Checks if this set is empty.
     * @return <code>true</code> if this set is empty.
     */
    boolean isEmpty();

    /**
     * Returns the number of artifacts in this set.
     * @return the number of artifacts in this set.
     */
    int size();

    /**
     * Returns a collection of all artifacts that have the given type.
     * @param type the type of the artifacts to return
     * @return the artifacts
     */
    Collection<Artifact> values(ArtifactType type);

    /**
     * Returns a collection of all artifacts
     * @return the artifacts
     */
    Collection<Artifact> values();

    /**
     * Returns the collection of removed artifacts
     * @return the removed artifacts
     */
    Collection<Artifact> removed();

}