/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.io.PrintWriter;
import java.util.LinkedList;

/**
 * <code>DumpHandler</code>...
 *
 */
public class DumpContext {

    private final PrintWriter out;

    private LinkedList<String> stack = new LinkedList<String>();

    public DumpContext(PrintWriter out) {
        this.out = out;
        stack.add("");
    }

    public void println(String str) {
        out.println(str);
    }
    
    public void println(boolean isLast, String str) {
        out.print(stack.getLast());
        out.print(isLast ? "`-- " : "|-- ");
        out.println(str);
    }

    public void printf(boolean isLast, String format, Object ... args) {
        println(isLast, String.format(format, args));
    }
    
    public void indent(boolean isLast) {
        String ind = stack.getLast() + (isLast ? "    " : "|   ");
        stack.addLast(ind);
    }

    public void outdent() {
        stack.removeLast();
    }

    public void flush() {
        out.flush();
    }

}