/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.util.Collection;
import java.util.TreeMap;

/**
 * <code>ImportInfo</code>...
 */
public interface ImportInfo {

    NodeNameList getNameList();

    void onModified(String path);

    void onNop(String path);

    void onCreated(String path);

    void onDeleted(String path);

    void onReplaced(String path);

    void onMissing(String path);

    void onError(String path, Exception e);

    TreeMap<String, Type> getModifications();

    Exception getError(String path);

    Collection<String> getToVersion();

    ImportInfo merge(ImportInfo info);
    
    /**
     * returns the number of non-NOP entries.
     * @return the number of modfiied entries.
     */
    int numModified();

    /**
     * returns the number of errors
     * @return the number of errors
     */
    int numErrors();

    public static enum Type {
        CRE,
        MOD,
        DEL,
        REP,
        NOP,
        ERR,
        MIS
    }
}