/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import javax.jcr.Item;
import javax.jcr.RepositoryException;

/**
 * The item filter is used to include or exclude a set of repository items.
 * It is usually part of a {@link ItemFilterSet}.
 *
 */
public interface ItemFilter extends Filter {

    /**
     * The "Catch all" item filter.
     */
    public static final ItemFilter ALL = new ItemFilter() {

        /**
         * Returns always <code>true</code>
         */
        public boolean matches(Item item, int depth) throws RepositoryException {
            return true;
        }

        /**
         * {@inheritDoc}
         */
        public void dump(DumpContext ctx, boolean isLast) {
            ctx.println(isLast, "ALL");
        }
    };

    /**
     * The "Miss all" item filter.
     */
    public static final ItemFilter NONE = new ItemFilter() {

        /**
         * Returns always <code>false</code>
         */
        public boolean matches(Item item, int depth) throws RepositoryException {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public void dump(DumpContext ctx, boolean isLast) {
            ctx.println(isLast, "NONE");
        }
    };

    /**
     * Checks if the given item matches this filters criteria. The given depth
     * is relative to some invoker related depth and may not reflect the
     * hierarchical depth of the item in the repository. It up to the
     * implementation how to deal with this value.
     * 
     * @param item the item to check
     * @param depth a relative depth.
     * @return <code>true</code> if this filter matches the criteria;
     *         <code>false</code> otherwise.
     * @throws RepositoryException if an error occurs.
     */
    public boolean matches(Item item, int depth) throws RepositoryException;
}