/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.ListIterator;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <code>SiblingNames</code>...
 */
public class NodeNameList {

    /**
     * default logger
     */
    private static final Logger log = LoggerFactory.getLogger(NodeNameList.class);

    private final LinkedHashSet<String> names = new LinkedHashSet<String>();

    public void addName(String name) {
        names.add(name);
    }

    public boolean contains(String name) {
        return names.contains(name);
    }

    public LinkedHashSet<String> getNames() {
        return names;
    }

    public boolean needsReorder(Node parent) throws RepositoryException {
        // could perform more comprehensive check
        return names.size() > 1 && parent.getPrimaryNodeType().hasOrderableChildNodes();
    }

    public boolean restoreOrder(Node parent) throws RepositoryException {
        // assume needsReorder check is performed
        // quick check if node is checked out
        if (!parent.isCheckedOut()) {
            log.warn("Unable to restore order of a checked-in node: " + parent.getPath());
            return false;
        }
        int size = names.size();
        String last = null;
        ArrayList<String> list = new ArrayList<String>(names);
        ListIterator<String> iter = list.listIterator(size);
        while (iter.hasPrevious()) {
            String prev = iter.previous();
            if (parent.hasNode(prev)) {
                log.debug("ordering {} before {}", prev, last);
                try {
                    parent.orderBefore(prev, last);
                } catch (Exception e) {
                    // probably an error in jcr2spi
                    String path = parent.getPath() + "/" + prev;
                    log.warn("Ignoring unexpected error during reorder of {}: {}", path, e.toString());
                }
                last = prev;
            }
        }
        return true;
    }

}