/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

/**
 * The item filter is used to include or exclude a set of paths.
 * It is usually part of a {@link PathFilterSet}.
 *
 */
public interface PathFilter extends Filter {

    /**
     * The "Catch all" item filter.
     */
    public static final PathFilter ALL = new PathFilter() {

        /**
         * Returns always <code>true</code>
         */
        public boolean matches(String path) {
            return true;
        }

        /**
         * {@inheritDoc}
         */
        public void dump(DumpContext ctx, boolean isLast) {
            ctx.println(isLast, "ALL");
        }

        /**
         * {@inheritDoc}
         */
        public boolean isAbsolute() {
            return true;
        }

        /**
         * {@inheritDoc}
         */
        public PathFilter translate(PathMapping mapping) {
            return this;
        }
    };

    /**
     * The "Miss all" item filter.
     */
    public static final PathFilter NONE = new PathFilter() {

        /**
         * Returns always <code>false</code>
         */
        public boolean matches(String path) {
            return false;
        }

        /**
         * {@inheritDoc}
         */
        public void dump(DumpContext ctx, boolean isLast) {
            ctx.println(isLast, "NONE");
        }

        /**
         * {@inheritDoc}
         */
        public boolean isAbsolute() {
            return true;
        }

        /**
         * {@inheritDoc}
         */
        public PathFilter translate(PathMapping mapping) {
            return this;
        }
    };

    /**
     * Checks if the given path matches this filters criteria.
     *
     * @param path the path to check
     * @return <code>true</code> if this filter matches the criteria;
     *         <code>false</code> otherwise.
     */
    boolean matches(String path);

    /**
     * Checks if the pattern is absolute, i.e. does not start with a wildcard.
     * @return <code>true</code> if pattern is absolute
     */
    boolean isAbsolute();

    /**
     * Translates this path filter with the given mapping. Note that only absolute filters can be translated.
     * @param mapping the mapping to apply
     * @return the new filter
     * @since 2.4.10
     */
    PathFilter translate(PathMapping mapping);
}