/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.fs.api;

/**
 * Provides an interface for a general path mapping.
 *
 * @since 2.4.10
 */
public interface PathMapping {

    /**
     * Implements an identity mapping
     */
    PathMapping IDENTITY = new PathMapping() {
        public String map(String path) {
            return path;
        }
    };

    /**
     * Maps the given path to a new location.
     * @param path the path
     * @return the mapped path.
     */
    String map(String path);
}