/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

/**
 * A <code>ProgressTrackerListener</code> can be provided by clients to
 * receive messages and errors during operations.
 */
public interface ProgressTrackerListener {

    /**
     * Is called when a message is received.
     * @param mode message mode
     * @param action action
     * @param path path or message the action was performed on
     */
    void onMessage(Mode mode, String action, String path);

    /**
     * Is called when an error is received.
     * @param mode message mode
     * @param path path or message
     * @param e error
     */
    void onError(Mode mode, String path, Exception e);

    /**
     * Message mode
     */
    enum Mode {
        
        /**
         * Argument represents a generic text.
         */
        TEXT,

        /**
         * Argument represents a path.
         */
        PATHS
    }

}