/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

/**
 * Provides a simple enumeration of possible serialization types.
 *
 */
public enum SerializationType {

    /**
     * specifies that the source type is not known
     */
    UNKOWN("x-vaultfs/unknown", "application/octet-stream"),

    /**
     * specifies that the source type is not serializable
     */
    NONE("x-vaultfs/none", "application/octet-stream"),

    /**
     * specifies that the source is XML but the type not known
     */
    XML_GENERIC("xml/generic", "text/xml"),

    /**
     * specifies that the source is a docview serialization
     */
    XML_DOCVIEW("xml/docview", "text/xml"),

    /**
     * specifies that the source is a compact node type definition
     */
    CND("text/cnd", "text/cnd"),

    /**
     * specifies that the source is generic data.
     */
    GENERIC("x-jcrfs/binary", "application/octet-stream");

    /**
     * the string representation
     */
    private final String name;

    /**
     * the content type of the serialization
     */
    private final String contentType;

    /**
     * Creates a new serialization type
     * @param name the (debug) name of the type
     * @param contentType the default content type
     */
    private SerializationType(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return name;
    }

    /**
     * Returns the name
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the content type of this serialization type
     * @return the content type
     */
    public String getContentType() {
        return contentType;
    }

    /**
     * Returns the serialization type with the given name
     * @param name the name to find
     * @return the serialization type or null
     */
    public static SerializationType fromName(String name) {
        for (SerializationType s: SerializationType.values()) {
            if (s.name.equals(name)) {
                return s;
            }
        }
        return null;
    }

}