/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.fs.api;

/**
 * Implements a simple path mapping that strips and prefixes a path.
 * @since 2.4.10
 */
public class SimplePathMapping implements PathMapping {

    private final String strip;

    private final String root;

    /**
     * Create a simple path mapping.
     * @param strip the string to strip from the beginning of the path
     * @param root the prefix to add to the path.
     */
    public SimplePathMapping(String strip, String root) {
        this.strip = strip;
        this.root = root;
    }

    /**
     * {@inheritDoc}
     */
    public String map(String path) {
        if (path.startsWith(strip)) {
            StringBuilder b = new StringBuilder(root);
            b.append(path.substring(strip.length()));
            return b.toString();
        } else {
            return path;
        }
    }
}